(function () {
    var datePickerOptions = {
        timepicker: false,
        format: 'm/d/Y',
        scrollMonth: false,
        defaultSelect: false,
        allowBlank: true,
        scrollInput: false,
        validateOnBlur: false
    };

   
    $(document).ready(function () {

        /*Disable Other textbox if 'Other doument' option is not selected in the dropdown after the page loaded*/
        var otherElements = $(".other");
        for (var i = 0; i < otherElements.length; i++) {
            var element = otherElements.eq(i);
            if (element.val().length === 0 && $('#drop' + i).val() !== "Other")
            {
                element.prop('disabled', true);
            }
        }

       
        
        //Display error message if user tried to add more than 9 additional objects
        $("#addbutton").click(function () {

            if (objectsTracker > 8) {
                $("#ObjectsMaxMessage").show();
                $("#ObjectsMaxMessage").show().delay(5000).fadeOut();
                return false;
            }

            var newTextBoxDiv = $(document.createElement('tr')).attr("id", 'TextBoxDiv' + counter);
            newTextBoxDiv.attr("class", "divRow");

            newTextBoxDiv.after().html('<td><input type="date" data_val_regex="Date of object must be in MM/DD/YYYY format." ' +
            'data_val_regex_pattern="^(([0]?[1-9]|1[0-2])/([0-2]?[0-9]|3[0-1])/[1-2]\\d{3})$" data_val_date="Date of object must be in MM/DD/YYYY format." ' +
            'type="text" class="date" aria_labelledby="aod-date-of-object-th" id="DisclosureInfo_AdditionalObjects_' + (counter) + '__ObjectDateString" ' +
            'name="DisclosureInfo.AdditionalObjects[' + counter + '].ObjectDateString" value="" data-val="true">' +
            '<span class="field-validation-valid" data-valmsg-replace="true" data-valmsg-for="DisclosureInfo.AdditionalObjects[' + counter + '].ObjectDateString"></span></td>' +
           '<td><select id ="drop' + counter + '"  name="DisclosureInfo.AdditionalObjects[' + counter + '].ObjectType" aria_labelledby="aod-document-type-th"  class="dropdown input-validation-error" data-val-required="Please select Documet Type" data-val="true">' +
           '<option value="">' + 'Select a Document' + '</option>' +
           '<option value="discharge summary">' + 'discharge summary' + '</option>' +
           '<option value="progress note">' + 'progress note' + '</option>' +
           '<option value="medications">' + 'medications' + '</option>' +
           '<option value="labwork">' + 'labwork' + '</option>' +
           '<option value="pathology">' + 'pathology' + '</option>' +
           '<option value="radiology">' + 'radiology' + '</option>' +
           '<option value="operative report">' + 'operative report' + '</option>' +
           '<option value="consult">' + 'consult' + '</option>' +
           '<option value="Other">' + 'Other' + '</option>' +
           '</select></td>' +
           '<td ><input aria_labelledby="aod-other-th" type="text" disabled="disabled" class="other" name="DisclosureInfo.AdditionalObjects[' + counter + '].OtherTypeText" id="DisclosureInfo_AdditionalObjects_' + counter + '__OtherTypeText" value="" >' +
            '</td><td aria-label="Remove this Additional Object Button" style="border:none"><a href="#" class="remove" style="border:none"><img alt="Remove this Additional Object Button" src="/Content/Images/remove.png" class="additionalObjectButton" /><input name="DisclosureInfo.AdditionalObjects[' + counter + '].Removed" id="DisclosureInfo_AdditionalObjects_' + counter + '__Removed" type="hidden" value="False" data-val-required="The Removed field is required." data-val="true"></a></td>'
            
           );

            newTextBoxDiv.appendTo("#TextBoxesGroup");

            //$.validator.unobtrusive.parse('#DisclosureInfo_AdditionalObjects_' + (counter) + '__ObjectDateString');

            counter++;
            objectsTracker++;
            $("#AddObjectsMessage").show();
            $("#AddObjectsMessage").show().delay(500).fadeOut();
           
        });

        $(document).on("click", ".remove", function (e) {
            {

                if (objectsTracker > 0) {
                    var flag = $(this).parent('td').find("input");
                    flag[0].value = "True";
                    $(this).parent('td').parent('tr').hide();
                    //counter--;
                    objectsTracker--;
                    //removedCount++
                   
                    $("#RemoveObjectsMessage").show();
                    $("#RemoveObjectsMessage").show().delay(500).fadeOut();
                }
            }
            return false;
        });

        //date picker code
         $('.date').datetimepicker(datePickerOptions);
         $('.xdsoft_datepicker.active').attr("aria-hidden", "true");
         $('.xdsoft_datetimepicker').attr("aria-hidden", "true");
        //end of ready function
    });

    /*Make Other textbox required if other is selected from dropdown and other textbox is empty*/
    $(document).on('input', '.other', function () {
        if ($(this).val().length === 0)
        {
            $(this).prop('required', true);
        }
    });

   /*Disabled Other textbox if not selected in the dropdown*/
    $(document).on('keypress', '.dropdown', function (event) {

        if (event.which == 13 || event.which == 32 ) {
            var parentRowID = $(this).closest('tr')[0].id;
            if ($(this).find('option:selected').text() != 'Other') {

                $('#' + parentRowID).find(".other").val('');
                $('#' + parentRowID).find(".other").prop('disabled', true);
                $('#' + parentRowID).find(".other").prop('required', false);
                //$('#' + parentRowID).find(".other").attr("required", "true");
                $('#' + parentRowID).find(".other").removeAttr('placeholder');
            } else {
                $('#' + parentRowID).find(".other").prop('disabled', false)
                $('#' + parentRowID).find(".other").prop('required', true);
                $('#' + parentRowID).find(".other").attr("placeholder", "Document Type");
                $('#' + parentRowID).find(".other").focus();

                $("#OtherMessage").show();
                $("#OtherMessage").show().delay(100).fadeOut();
            }
        }
    });

    $(document).on('click', '.dropdown', function (event) {

        if (event.which == 1 ) {
            var parentRowID = $(this).closest('tr')[0].id;
            if ($(this).find('option:selected').text() != 'Other') {

                $('#' + parentRowID).find(".other").val('');
                $('#' + parentRowID).find(".other").prop('disabled', true);
                $('#' + parentRowID).find(".other").prop('required', false);
                //$('#' + parentRowID).find(".other").attr("required", "true");
                $('#' + parentRowID).find(".other").removeAttr('placeholder');
            } else {
                $('#' + parentRowID).find(".other").prop('disabled', false)
                $('#' + parentRowID).find(".other").prop('required', true);
                $('#' + parentRowID).find(".other").attr("placeholder", "Document Type");
                $('#' + parentRowID).find(".other").focus();

                $("#OtherMessage").show();
                $("#OtherMessage").show().delay(100).fadeOut();
            }
        }
    });
    

    
    //Add date picker to newly created objects
    $(document).on('click', '.date', function () {
        $('.date').datetimepicker(datePickerOptions);
        $('.xdsoft_datepicker.active').attr("aria-hidden", "true");
        $('.xdsoft_datetimepicker').attr("aria-hidden", "true");
    });


    $(document).on('keyup blur', '.other', function () {
        $('input:text[class="other"]').bind('keyup blur', function () {
            $(this).val($(this).val().replace(/[^a-zA-Z -.,]/g, ''));
            if ($(this).val().length > 100) {
                $(this).val($(this).val().substring(0, 99))
            }
        });
    });




    //end of closure
})();